/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * Option.java
 *
 * Created on 11-06-2011, 07:51:37
 */
package Presentation;

import diaoc.CustomCellRenderer;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

/**
 *
 * @author Nixforest
 */
public class Option extends javax.swing.JInternalFrame {

    /** Creates new form Option */
    public Option() {
        initComponents();
        LoadImage(optionImage[0]);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        cbxGiaoDien = new javax.swing.JComboBox();
        pnlImage = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        cbxNgonNgu = new javax.swing.JComboBox();
        btnLuu = new javax.swing.JButton();
        btnThoat = new javax.swing.JButton();

        setClosable(true);
        setTitle(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("titleOption"));
        addInternalFrameListener(new javax.swing.event.InternalFrameListener() {
            public void internalFrameActivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosed(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameClosing(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeactivated(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameDeiconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameIconified(javax.swing.event.InternalFrameEvent evt) {
            }
            public void internalFrameOpened(javax.swing.event.InternalFrameEvent evt) {
                formInternalFrameOpened(evt);
            }
        });

        jLabel1.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("interface"));

        pnlImage.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        pnlImage.setMaximumSize(new java.awt.Dimension(590, 370));
        pnlImage.setMinimumSize(new java.awt.Dimension(590, 370));
        pnlImage.setPreferredSize(new java.awt.Dimension(590, 370));

        javax.swing.GroupLayout pnlImageLayout = new javax.swing.GroupLayout(pnlImage);
        pnlImage.setLayout(pnlImageLayout);
        pnlImageLayout.setHorizontalGroup(
            pnlImageLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 586, Short.MAX_VALUE)
        );
        pnlImageLayout.setVerticalGroup(
            pnlImageLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 383, Short.MAX_VALUE)
        );

        jLabel2.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("language"));

        cbxNgonNgu.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Tiếng Việt", "Tiếng Anh" }));

        btnLuu.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("save"));
        btnLuu.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnLuuActionPerformed(evt);
            }
        });

        btnThoat.setText(java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("close"));
        btnThoat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnThoatActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jLabel1)
                    .addComponent(jLabel2)
                    .addComponent(btnLuu, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(btnThoat, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(cbxGiaoDien, 0, 129, Short.MAX_VALUE)
                    .addComponent(cbxNgonNgu, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(pnlImage, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(pnlImage, javax.swing.GroupLayout.DEFAULT_SIZE, 387, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(cbxGiaoDien, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel2)
                        .addGap(18, 18, 18)
                        .addComponent(cbxNgonNgu, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(btnLuu)
                        .addGap(18, 18, 18)
                        .addComponent(btnThoat)))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void formInternalFrameOpened(javax.swing.event.InternalFrameEvent evt) {//GEN-FIRST:event_formInternalFrameOpened
        cbxGiaoDien.addItem("Windows");
        cbxGiaoDien.addItem("JTattoo - Fast");
        cbxGiaoDien.addItem("JTattoo - Graphite");
        cbxGiaoDien.addItem("JTattoo - HiFi");
        cbxGiaoDien.addItem("JTattoo - Luna");
        cbxGiaoDien.addItem("JTattoo - McWin");
        cbxGiaoDien.addItem("JTattoo - Mint");
        cbxGiaoDien.addItem("JTattoo - Smart");
        cbxGiaoDien.addItem("Lipstik");
        cbxGiaoDien.addItem("Liquid");
        cbxGiaoDien.addItem("NimROD");
        cbxGiaoDien.addItem("Napkin");
        cbxGiaoDien.addItem("Tiny");
        
        cbxGiaoDien.addItemListener(new ItemListener() {

            public void itemStateChanged(ItemEvent e) {
                int i = cbxGiaoDien.getSelectedIndex();
                LoadImage(optionImage[i]);
                pnlImage.revalidate();
            }
        });
        FileReader fr;
        try {
            fr = new FileReader("config.dat");
            
            BufferedReader input = new BufferedReader(fr);
            input.readLine();
            String ui = input.readLine();
            int n = Integer.parseInt(ui);
            cbxNgonNgu.setSelectedIndex(n);
        } catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(rootPane, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("can not open file"));
            Logger.getLogger(Option.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(rootPane, ex.toString());
            Logger.getLogger(Option.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_formInternalFrameOpened

    private void btnLuuActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnLuuActionPerformed
        //Ghi file
        FileOutputStream fos;
        try {
            fos = new FileOutputStream("config.dat", false);
            PrintWriter pw= new PrintWriter(fos);
            pw.println(optionUI[cbxGiaoDien.getSelectedIndex()]);
            pw.println(cbxNgonNgu.getSelectedIndex());
            pw.println(Utilities.Utilities.host);
            pw.println(Utilities.Utilities.port);
            pw.close();
            JOptionPane.showMessageDialog(rootPane,
                    java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("change update"));
            this.dispose();
        } catch (FileNotFoundException ex) {
            JOptionPane.showMessageDialog(rootPane, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("can not save"));
            Logger.getLogger(Option.class.getName()).log(Level.SEVERE, null, ex);
        } 
    }//GEN-LAST:event_btnLuuActionPerformed

    private void btnThoatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnThoatActionPerformed
        if (JOptionPane.showConfirmDialog(rootPane, java.util.ResourceBundle.getBundle("Presentation/" + frmMain.resource).getString("really want to close"), java.util.ResourceBundle.getBundle("Presentation/en").getString("warn"), JOptionPane.YES_NO_OPTION) == 0){
            this.dispose();
        }else {
        }
    }//GEN-LAST:event_btnThoatActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnLuu;
    private javax.swing.JButton btnThoat;
    private javax.swing.JComboBox cbxGiaoDien;
    private javax.swing.JComboBox cbxNgonNgu;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel pnlImage;
    // End of variables declaration//GEN-END:variables
    private final String[] optionUI = new String[]{
        "com.sun.java.swing.plaf.windows.WindowsLookAndFeel",
        "com.jtattoo.plaf.fast.FastLookAndFeel",
        "com.jtattoo.plaf.graphite.GraphiteLookAndFeel",
        "com.jtattoo.plaf.hifi.HiFiLookAndFeel",
        "com.jtattoo.plaf.luna.LunaLookAndFeel",
        "com.jtattoo.plaf.mcwin.McWinLookAndFeel",
        "com.jtattoo.plaf.mint.MintLookAndFeel",
        "com.jtattoo.plaf.smart.SmartLookAndFeel",
        "com.lipstikLF.LipstikLookAndFeel",
        "com.birosoft.liquid.LiquidLookAndFeel",
        "com.nilo.plaf.nimrod.NimRODLookAndFeel",
        "napkin.NapkinLookAndFeel",
        "de.muntjak.tinylookandfeel.TinyLookAndFeel"
    };
    private final String[] optionImage = new String[]{
        "window.png",
        "fast.png",
        "graphite.png",
        "hifi.png",
        "luna.png",
        "mac.png",
        "mint.png",
        "smart.png",
        "lipstik.png",
        "liquid.png",
        "nimrod.png",
        "napkin.png",
        "tiny.png"
    };
    private void LoadImage(String str){
        try{
            pnlImage.setLayout(new FlowLayout());
            pnlImage.removeAll();
            URL url = getClass().getResource("../Images/ui/" + str);
            Image img = Toolkit.getDefaultToolkit().getImage(url).getScaledInstance(590, 370, BufferedImage.SCALE_SMOOTH);                
            ImageIcon icon = new ImageIcon(img);
            JPanel p = new JPanel();
            p.add(new JLabel(icon));
            Vector v = new Vector();
            v.addElement(p);
            JList com = new JList(v);
            com.setCellRenderer(new CustomCellRenderer());
            com.setBounds(new Rectangle(pnlImage.getWidth(), pnlImage.getHeight()));
            pnlImage.add(com);
        }catch (Exception ex) {
            JOptionPane.showMessageDialog(this.rootPane, ex.toString());
            Logger.getLogger(MyPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}
